$(function() {
    "use strict";

    $(document).ready(function() {

        $(".expandall").attr({
            tabindex: 0,
            role: 'button',
            'aria-expanded': false
        }).on('click keydown', function(e) {
            if (e.type === 'click' || e.key === 'Enter' || e.key === ' ') {
                $(this).toggleClass("expanded");
                $('.expandall .collapsed-label').toggleClass('hidden');
                $('.expandall .expanded-label').toggleClass('hidden');
                if ($('.expandall .collapsed-label').hasClass('hidden')) {

                    $('.summary-content').removeClass('hidden');
                    $('.detail-content').addClass('hidden');
                    $('.expand-collapse-toggle-btn .expand-btn').removeClass('hidden');
                    $('.expand-collapse-toggle-btn .collapse-btn').addClass('hidden');
                } else {
                    $('.summary-content').addClass('hidden');
                    $('.detail-content').removeClass('hidden');
                    $('.expand-collapse-toggle-btn .expand-btn').addClass('hidden');
                    $('.expand-collapse-toggle-btn .collapse-btn').removeClass('hidden');
                }
                if($('.expand-collapse-toggle-btn').hasClass('hidden')){
                    var onlySummary = $('.expand-collapse-toggle-btn.hidden');
                    onlySummary.closest('.expand-collapse-content').find('.summary-content').removeClass('hidden');
                }

                $('li.nav-in-page-item.nav-parent-item button.btn').each(function() {
                    if ($(this).hasClass('expanded') !== $(this).hasClass('collapsed')) {
                        $(this).click();
                    }
                });

                var isExpanded = $(this).attr('aria-expanded') === 'true';
                
                $('li.nav-in-page-item.nav-parent-item button.btn').each(function () {
                    if (!isExpanded && $(this).hasClass('collapsed')) {
                        $(this).click();
                    }
                    if (isExpanded && ! $(this).hasClass('collapsed')) {
                        $(this).click();
                    }
                });

                $(this).attr('aria-expanded', !isExpanded);
            }
        });

        $('.open-print-view').attr({
            tabindex: 0,
            role: 'button'
        }).on('click keydown', function(e) {
            if (e.type === 'click' || e.key === 'Enter' || e.key === ' ') {
                e.preventDefault(); // Prevent default link behavior

                // Get the current page URL
                var currentPageUrl = window.location.href;

                // Check if the current URL already contains a query string
                var newUrl = currentPageUrl;
                if(currentPageUrl.indexOf('PrintView=true') === -1){
                    if (currentPageUrl.indexOf('?') === -1) {
                        // If no query string exists, append "?PrintView=true"
                        newUrl = currentPageUrl + '?PrintView=true';
                    } else {
                        // If a query string exists, append "&PrintView=true"
                        newUrl = currentPageUrl + '&PrintView=true';
                    }
                }

                // Open the new tab with the modified URL
                window.open(newUrl, '_blank');
            }
        });

        window.addEventListener('load', function() {
            // Get the current page URL
            var currentPageUrl = window.location.href;

            // Check if the URL contains "?PrintView=true" or "&PrintView=true"
            if (currentPageUrl.indexOf('?PrintView=true') !== -1 || currentPageUrl.indexOf('&PrintView=true') !== -1) {
                // Open the print screen
                $('.expand-collapse-content').each(function() {
                    var $this = $(this);
                    if (!$this.find('.expand-collapse-toggle-btn').hasClass('hidden')) {
                        $this.find('.summary-content').addClass('hidden');
                        $this.find('.detail-content').removeClass('hidden');
                    }
                });
                
                $('.print-expand-action-bar').addClass('hidden');
                $('.expand-collapse-toggle-btn').addClass('hidden');
                $('.collapse-btn').addClass('hidden');
                $('.expand-btn').addClass('hidden');
                $('.nav-in-page-container').addClass('hidden');

                var hideElements = $('.hideElements').val().trim();
                if (hideElements.indexOf(',') > -1) {
                    hideElements.split(',').forEach(function(element) {
                        $(element).addClass('hidden');
                    });
                } else {
                    $(hideElements).addClass('hidden');
                }

                window.print();
            }
        });
    });
});